<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/functions.php');
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

// Configurações do arquivo de relatórios 📁
$reports_file = __DIR__ . '/reports.json';
$reports_data = [];

// Carrega dados existentes do arquivo de relatórios 📤
if (file_exists($reports_file)) {
    $reports_content = file_get_contents($reports_file);
    $reports_data = json_decode($reports_content, true);
}

// Processamento das ações 🛠️
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ação de deletar registro 🗑️
    if (isset($_POST["delete_report"])) {
        $index_to_delete = (int)$_POST["report_index"];
        
        if (isset($reports_data[$index_to_delete])) {
            // Remove o registro do array
            array_splice($reports_data, $index_to_delete, 1);
            
            // Salva no arquivo JSON 💾
            if (file_put_contents($reports_file, json_encode($reports_data, JSON_PRETTY_PRINT))) {
                $success_message = "✅ Registro deletado com sucesso!";
            } else {
                $error_message = "❌ Erro ao deletar registro. Verifique as permissões do arquivo.";
            }
        } else {
            $error_message = "❌ Registro não encontrado para deletar.";
        }
    }
    
    // Ação de limpar todos os registros 🧹
    if (isset($_POST["clear_all"])) {
        if (file_put_contents($reports_file, json_encode([], JSON_PRETTY_PRINT))) {
            $reports_data = [];
            $success_message = "🧹 Todos os registros foram removidos com sucesso!";
        } else {
            $error_message = "❌ Erro ao limpar registros. Verifique as permissões do arquivo.";
        }
    }
}

$page_title = "📊 Gerenciamento de Relatórios";

$page_content = '<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <h2 class="mb-9">📋 Relatórios de Dispositivos</h2>';

if (!empty($success_message)) {
    $page_content .= '<div class="alert alert-success" role="alert">' . htmlspecialchars($success_message) . '</div>';
}

if (!empty($error_message)) {
    $page_content .= '<div class="alert alert-danger" role="alert">' . htmlspecialchars($error_message) . '</div>';
}

$page_content .= '<div class="row">
                <div class="col-xl-12">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>📱 Dispositivo ID</th>
                                    <th>🛠️ Modelo</th>
                                    <th>💬 Mensagem</th>
                                    <th>⏱️ Data/Hora</th>
                                    <th>⚙️ Ações</th>
                                </tr>
                            </thead>
                            <tbody>';

if (empty($reports_data)) {
    $page_content .= '<tr>
                        <td colspan="6" class="text-center text-muted py-5">📭 Nenhum relatório encontrado</td>
                    </tr>';
} else {
    foreach ($reports_data as $index => $report) {
        $page_content .= '<tr>
                            <td>' . ($index + 1) . '</td>
                            <td><code>' . htmlspecialchars($report['device_id']) . '</code></td>
                            <td>' . htmlspecialchars($report['device_model']) . '</td>
                            <td>' . htmlspecialchars($report['message']) . '</td>
                            <td>' . htmlspecialchars($report['timestamp']) . '</td>
                            <td>
                                <form method="POST" action="" style="display:inline;">
                                    <input type="hidden" name="report_index" value="' . $index . '">
                                    <button type="submit" name="delete_report" class="btn btn-sm btn-danger" 
                                        onclick="return confirm(\'⚠️ Tem certeza que deseja deletar este registro?\')">
                                        🗑️ Deletar
                                    </button>
                                </form>
                            </td>
                        </tr>';
    }
}

$page_content .= '</tbody>
                        </table>
                    </div>';

// Botão para limpar todos os registros
if (!empty($reports_data)) {
    $page_content .= '<div class="mt-4 text-end">
                        <form method="POST" action="">
                            <button type="submit" name="clear_all" class="btn btn-warning" 
                                onclick="return confirm(\'⚠️ ATENÇÃO! Isso apagará TODOS os registros. Continuar?\')">
                                🧹 Limpar Todos os Registros
                            </button>
                        </form>
                    </div>';
}

$page_content .= '</div>
            </div>
        </div>
    </div>
</div>';

include 'includes/layout.php';
?>