<?php

// Decodifica o link base64
$encoded_link = '';
$decoded_link = base64_decode($encoded_link);

// Verifica se o conteúdo do site pode ser carregado diretamente
function fetch_content($url) {
    if (empty($url)) return false; // Se estiver vazio, já retorna false
    $context = stream_context_create(array('http' => array('timeout' => 5)));
    $content = @file_get_contents($url, false, $context);
    return $content ?: false;
}

// Tenta obter o conteúdo do site
$content = fetch_content($decoded_link);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sport Webview</title>
    <style>
        body {
            background-color: #000;
            margin: 0;
            padding: 0;
            overflow: hidden;
        }

        .container {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            height: 100vh;
        }

        iframe {
            width: 100%;
            height: 100%;
            border: none;
            transition: transform 0.3s ease-out;
        }

        .warning {
            color: white;
            text-align: center;
            margin: 20px;
            font-size: 18px;
        }

        .warning a {
            color: #00f;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <?php if (!empty($decoded_link) && $content): ?>
        <div class="container">
            <iframe srcdoc="<?php echo htmlspecialchars($content); ?>"></iframe>
        </div>
    <?php elseif (!empty($decoded_link)): ?>
        <div class="warning">
            Não foi possível carregar o conteúdo do link fornecido.<br>
            <a href="<?php echo htmlspecialchars($decoded_link); ?>" target="_blank">Clique aqui para tentar abrir manualmente</a>.
        </div>
    <?php else: ?>
        <div class="warning">
            Nenhum link foi configurado no painel ainda.
        </div>
    <?php endif; ?>
</body>
</html>