<?php
// /api/lista_apps.php

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');

$code = isset($_GET['code']) ? preg_replace('/[^a-zA-Z0-9]/', '', $_GET['code']) : null;

if ($code) {
    $filePath = __DIR__ . "/apps_individual/{$code}.json";

    if (file_exists($filePath)) {
        // Lê e retorna o conteúdo do JSON específico
        echo file_get_contents($filePath);
        exit;
    } else {
        // Arquivo não encontrado
        http_response_code(404);
        echo json_encode(["error" => "Arquivo {$code}.json não encontrado"], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }
}

// Caso não tenha passado o code, retorna os dados do banco normalmente
try {
    $dbPath = __DIR__ . '/max.db';

    if (!file_exists($dbPath)) {
        throw new Exception("Banco de dados não encontrado.");
    }

    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db->query("SELECT name, package, apk_url, icon_url, active FROM apps WHERE active = 1");

    $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($apps) {
        foreach ($apps as &$app) {
            $app['status_text'] = $app['active'] ? 'Ativo' : 'Inativo';
        }
        echo json_encode($apps, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    } else {
        echo json_encode([], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
