<?php
$data = json_decode(file_get_contents("php://input"), true);
if ($data) {
    $jsonFile = 'reports.json';

    // Pega dados atuais, ou inicializa um array vazio
    $currentData = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];

    // Adiciona nova mensagem ao array
    $currentData[] = $data;

    // Salva no arquivo
    file_put_contents($jsonFile, json_encode($currentData, JSON_PRETTY_PRINT));

    echo json_encode(["status" => "success"]);
} else {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Dados inválidos"]);
}
