<?php
header('Content-Type: application/json');

// Configuração do banco de dados SQLite
$dbPath = __DIR__ . '/database.db'; // Ajuste este caminho

try {
    // Conexão com o banco SQLite
    $conn = new PDO("sqlite:$dbPath");
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Obter dados JSON da requisição
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    // Validação dos dados obrigatórios
    if (!isset($data['device_id'])) {
        throw new Exception("Device ID é obrigatório");
    }
    
    // Extrair dados da requisição
    $deviceId = $data['device_id'];
    $isOnline = isset($data['is_online']) ? (int)$data['is_online'] : 0;
    $deviceModel = isset($data['device_model']) ? $data['device_model'] : 'Desconhecido';
    $lastConnection = date('Y-m-d H:i:s');
    $uptime = isset($data['uptime']) ? $data['uptime'] : '0';
    $ipAddress = isset($data['ip_address']) ? $data['ip_address'] : null;
    $firstSeen = isset($data['first_seen']) ? $data['first_seen'] : $lastConnection;
    
    // Verificar se o dispositivo já existe
    $stmt = $conn->prepare("SELECT id FROM user_connections WHERE device_id = :device_id");
    $stmt->bindParam(':device_id', $deviceId);
    $stmt->execute();
    
    if ($stmt->fetch()) {
        // Atualizar registro existente
        $stmt = $conn->prepare("
            UPDATE user_connections 
            SET 
                device_model = :device_model,
                last_connection = :last_connection,
                uptime = :uptime,
                is_online = :is_online,
                ip_address = :ip_address
            WHERE device_id = :device_id
        ");
    } else {
        // Inserir novo registro
        $stmt = $conn->prepare("
            INSERT INTO user_connections (
                device_id, 
                device_model, 
                last_connection, 
                uptime, 
                is_online, 
                ip_address,
                first_seen
            ) VALUES (
                :device_id, 
                :device_model, 
                :last_connection, 
                :uptime, 
                :is_online, 
                :ip_address,
                :first_seen
            )
        ");
        $stmt->bindParam(':first_seen', $firstSeen);
    }
    
    // Bind dos parâmetros
    $stmt->bindParam(':device_id', $deviceId);
    $stmt->bindParam(':device_model', $deviceModel);
    $stmt->bindParam(':last_connection', $lastConnection);
    $stmt->bindParam(':uptime', $uptime);
    $stmt->bindParam(':is_online', $isOnline, PDO::PARAM_INT);
    $stmt->bindParam(':ip_address', $ipAddress);
    
    // Executar a query
    $stmt->execute();
    
    // Retornar sucesso
    echo json_encode([
        'success' => true,
        'message' => 'Status atualizado com sucesso',
        'device_id' => $deviceId,
        'is_online' => $isOnline
    ]);
    
} catch(PDOException $e) {
    // Retornar erro de banco de dados
    echo json_encode([
        'success' => false,
        'error' => 'Erro no banco de dados: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    // Retornar outros erros
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

// Fechar conexão
$conn = null;
?>