<?php
header('Content-Type: application/json');

// Carrega as configurações do JSON
$config = json_decode(file_get_contents(__DIR__ . '/config.json'), true);

if (!empty($_GET['code'])) {
    try {
        $code = $_GET['code'];
        $id_dispositivo = isset($_GET['id_dispositivo']) ? $_GET['id_dispositivo'] : null;
        $dbPath = __DIR__ . '/max.db';
        $db = new PDO('sqlite:' . $dbPath);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Verifica se o código já existe
        $stmt = $db->prepare("SELECT status, expiration_date FROM activations WHERE code = :code LIMIT 1");
        $stmt->execute([':code' => $code]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            // Já existe: retorna dados
            echo json_encode([
                'status' => $row['status'],
                'expiration_date' => $row['expiration_date'] ?: null
            ]);
        } else {
            // Usa valores do config.json
            $status = $config['default_status'];
            $expiration_date = date('Y-m-d', strtotime('+' . $config['default_expiration_days'] . ' days'));
            $user = 'Teste Aut';

            $insertStmt = $db->prepare("INSERT INTO activations (code, status, expiration_date, user, id_dispositivo) 
                                        VALUES (:code, :status, :expiration_date, :user, :id_dispositivo)");
            $insertStmt->execute([
                ':code' => $code,
                ':status' => $status,
                ':expiration_date' => $expiration_date,
                ':user' => $user,
                ':id_dispositivo' => $id_dispositivo
            ]);

            echo json_encode([
                'status' => $status,
                'expiration_date' => $expiration_date
            ]);
        }
    } catch (Exception $e) {
        echo json_encode(['status' => 'pending', 'expiration_date' => null]);
    }
} else {
    echo json_encode(['status' => 'pending', 'expiration_date' => null]);
}
?>