/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.IOException;

public class DexStringIdsBlock
extends DexParser {
    private String[] strings = null;
    private DexPointerBlock dexPointerBlock = null;
    private DexSignatureBlock dexSignatureBlock;
    private static final String HEXCHAR = "0123456789ABCDEF";

    @Override
    public void parse() throws IOException {
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        int stringsSize = (int)this.dexPointerBlock.getStringIdsSize();
        this.file.seek(this.dexPointerBlock.getStringIdsOffset());
        long[] stringsPos = new long[stringsSize];
        int i = 0;
        while (i < stringsSize) {
            stringsPos[i] = this.readFileOffset();
            this.dump("string[" + i + "]: at 0x" + this.dumpLong(stringsPos[i]));
            ++i;
        }
        this.setDumpOff();
        this.strings = new String[stringsSize];
        i = 0;
        while (i < this.strings.length) {
            this.file.seek(stringsPos[i]);
            this.strings[i] = this.readString();
            this.dump("// string[" + i + "]: " + this.strings[i]);
            ++i;
        }
        this.setDumpOn();
    }

    public int getStringsSize() {
        return (int)this.dexPointerBlock.getStringIdsSize();
    }

    public String getString(int idx) {
        return this.strings[idx];
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public static String escapeString(String input) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c;
            char ci = c = input.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else if (ci >= ' ' && ci <= '\u007f') {
                b.append(c);
            } else if (ci == '\u0000') {
                b.append("\\0");
            } else if (ci == '\u0007') {
                b.append("\\a");
            } else if (ci == '\b') {
                b.append("\\b");
            } else if (ci == '\t') {
                b.append("\\t");
            } else if (ci == '\f') {
                b.append("\\f");
            } else if (ci == '\n') {
                b.append("\\n");
            } else if (ci == '\r') {
                b.append("\\r");
            } else {
                b.append("\\u");
                b.append(HEXCHAR.charAt((ci & 0xF000) >> 12));
                b.append(HEXCHAR.charAt((ci & 0xF00) >> 8));
                b.append(HEXCHAR.charAt((ci & 0xF0) >> 4));
                b.append(HEXCHAR.charAt(ci & 0xF));
            }
            ++i;
        }
        return new String(b);
    }
}

